<?php
/**
 * WebEngine Lottery Plugin
 * https://webenginecms.org/
 * 
 * @version 2.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2017 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

try {
	$Lottery = new \Plugin\Lottery\Lottery();
	$lotteryResults = $Lottery->getLastLotteryData();
	
	// LOTTERY
	echo '<div class="lottery-container">';
		echo '<div class="lottery-container-menu">';
			echo '<ul>';
				echo '<li><a href="'.__LOTTERY_HOME__.'">'.lang('lottery_menu_1', true).'</a></li>';
				if(isLoggedIn()) echo '<li><a href="'.__LOTTERY_HOME__.'history/">'.lang('lottery_menu_2', true).'</a></li>';
				if(isLoggedIn()) echo '<li><a href="'.__LOTTERY_HOME__.'stash/">'.lang('lottery_menu_3', true).'</a></li>';
				echo '<li><a href="'.__LOTTERY_HOME__.'results/">'.lang('lottery_menu_4', true).'</a></li>';
				echo '<li><a href="'.config('website_forum_link', true).'" target="_blank">'.lang('lottery_menu_5', true).'</a></li>';
			echo '</ul>';
		echo '</div>';
		echo '<div class="lottery-container-head"></div>';
		if(is_array($lotteryResults)) {
			echo '<div class="lottery-container-content-results">';
				echo '<div class="lottery-results-title">'.lang('lottery_txt_21', true).'</div>';
				echo '<table class="table">';
					echo '<tr>';
						echo '<th>'.lang('lottery_txt_15', true).'</th>';
						echo '<th>'.lang('lottery_txt_16', true).'</th>';
						echo '<th>'.lang('lottery_txt_17', true).'</th>';
						echo '<th>'.lang('lottery_txt_18', true).'</th>';
					echo '</tr>';
					echo '<tr>';
						echo '<td>'.$lotteryResults['winners_4'].'</td>';
						echo '<td>'.$lotteryResults['winners_3'].'</td>';
						echo '<td>'.$lotteryResults['winners_2'].'</td>';
						echo '<td>'.$lotteryResults['winners_1'].'</td>';
					echo '</tr>';
				echo '</table>';
			echo '</div>';
			echo '<div class="lottery-container-numbers">';
				echo '<div class="lottery-container-number">'.$lotteryResults['number1'].'</div>';
				echo '<div class="lottery-container-number">'.$lotteryResults['number2'].'</div>';
				echo '<div class="lottery-container-number">'.$lotteryResults['number3'].'</div>';
				echo '<div class="lottery-container-number">'.$lotteryResults['number4'].'</div>';
			echo '</div>';
		}
	echo '</div>';
	
} catch (Exception $ex) {
	message('error', $ex->getMessage());
}